<?php // @codingStandardsIgnoreStart

namespace Elementor;

class goto_tour_post extends Goto_Carousel_Base {
	public function get_name() {
		return 'tour-post';
	}

	public function get_categories() {
		return array( 'goto-theme' );
	}

	public function get_title() {
		return esc_html__( 'Tour', 'goto' );
	}

	public function get_icon() {
		return 'eicon-document-file';
	}

	protected function register_controls() {
		$this->sectionLayout();
		$this->sectionQuery();
		$this->sectionPagination();
		$this->sectionArrows();
		$this->sectionDots();
	}

	private function sectionLayout(){
		$this->start_controls_section( 't_layout', array(
			'label' => esc_html__( 'Layout', 'goto' ),
		));

		$this->add_control( 'layout', array(
			'type'    => Controls_Manager::SELECT,
			'label'   => esc_html__( 'Layout', 'goto' ),
			'default' => 'grid',
			'options' => array(
				'grid'     => esc_html__( 'Grid', 'goto' ),
				'carousel' => esc_html__( 'Carousel', 'goto' ),
			),
		));

		$this->add_control( 'arrows', array(
			'type'         => Controls_Manager::SWITCHER,
			'label'        => esc_html__( 'Arrows', 'goto' ),
			'default'      => 'yes',
			'label_on'     => esc_html__( 'Yes', 'goto' ),
			'label_off'    => esc_html__( 'No', 'goto' ),
			'return_value' => 'yes',
			'condition'    => array(
				'layout' => 'carousel'
			)
		));

		$this->add_control( 'dots', array(
			'type'         => Controls_Manager::SWITCHER,
			'label'        => esc_html__( 'Dots', 'goto' ),
			'default'      => '',
			'label_on'     => esc_html__( 'Yes', 'goto' ),
			'label_off'    => esc_html__( 'No', 'goto' ),
			'return_value' => 'yes',
			'condition'    => array(
				'layout' => 'carousel'
			)
		));

		$this->add_responsive_control( 'columns', array(
			'type'           => Controls_Manager::SELECT,
			'label'          => esc_html__( 'Columns', 'goto' ),
			'default'        => 3,
			'tablet_default' => 2,
			'mobile_default' => 1,
			'options'        => array(
				1 => 1,
				2 => 2,
				3 => 3,
				4 => 4,
				5 => 5,
			),
		));

		$this->add_control( 'per_page', array(
			'type'    => Controls_Manager::NUMBER,
			'label'   => esc_html__( 'Posts Per Page', 'goto' ),
			'default' => 6,
			'min'     => -1,
			'max'     => 100,
		));

		$this->add_control( 'pagi', array(
			'type'         => Controls_Manager::SWITCHER,
			'label'        => esc_html__( 'Pagination', 'goto' ),
			'default'      => '',
			'label_on'     => esc_html__( 'Yes', 'goto' ),
			'label_off'    => esc_html__( 'No', 'goto' ),
			'return_value' => 'yes',
			'condition'    => array(
				'layout' => 'grid'
			)
		));

		$this->end_controls_section();
	}

	private function sectionQuery(){
		$this->start_controls_section( 't_query', array(
			'label'     => esc_html__( 'Query', 'goto' ),
			'condition' => array(
				't_layout.per_page!' => 0
			),
		));

		$this->add_control( 'narrow', array(
			'type'    => Controls_Manager::SELECT,
			'label'   => esc_html__( 'Narrow Data Source', 'goto' ),
			'default' => 'cat',
			'options' => array(
				'cat'  => esc_html__( 'Categories', 'goto' ),
				'dest' => esc_html__( 'Destinations', 'goto' ),
				'post' => esc_html__( 'Posts', 'goto' ),
			),
		));

		$this->add_control( 'cat', array(
			'type'      => Controls_Manager::SELECT2,
			'label'     => esc_html__( 'Enter categories', 'goto' ),
			'multiple'  => true,
			'options'   => goto_get_narrow_data( 'cat' ),
			'condition' => array(
				'narrow' => 'cat'
			),
		));

		$this->add_control( 'dest', array(
			'type'      => Controls_Manager::SELECT2,
			'label'     => esc_html__( 'Enter destinations', 'goto' ),
			'multiple'  => true,
			'options'   => goto_get_narrow_data( 'dest' ),
			'condition' => array(
				'narrow' => 'dest'
			),
		));

		$this->add_control( 'post', array(
			'type'      => Controls_Manager::SELECT2,
			'label'     => esc_html__( 'Enter posts', 'goto' ),
			'multiple'  => true,
			'options'   => goto_get_narrow_data( 'post' ),
			'condition' => array(
				'narrow' => 'post'
			),
		));

		$this->add_control( 'orderby', array(
			'type'    => Controls_Manager::SELECT,
			'label'   => esc_html__( 'Order By', 'goto' ),
			'default' => 'date',
			'options' => array(
				'none'     => esc_html__( 'None', 'goto' ),
				'post__in' => esc_html__( 'Post In', 'goto' ),
				'date'     => esc_html__( 'Date', 'goto' ),
				'title'    => esc_html__( 'Title', 'goto' ),
				'ID'       => esc_html__( 'ID', 'goto' ),
				'author'   => esc_html__( 'Author', 'goto' ),
				'rand'     => esc_html__( 'Random', 'goto' ),
				'modified' => esc_html__( 'Modified', 'goto' ),
			),
		));

		$this->add_control( 'order', array(
			'type'    => Controls_Manager::SELECT,
			'label'   => esc_html__( 'Order', 'goto' ),
			'default' => 'DESC',
			'options' => array(
				'ASC'  => esc_html__( 'ASC', 'goto' ),
				'DESC' => esc_html__( 'DESC', 'goto' ),
			),
		));

		$this->end_controls_section();
	}

	private function sectionPagination(){
		$this->start_controls_section( 't_pagi', array(
			'label'     => esc_html__( 'Pagination', 'goto' ),
			'condition' => array(
				't_layout.layout' => 'grid',
				't_layout.pagi' => 'yes',
			),
		));

		$this->add_responsive_control( 'pagi_position', array(
			'type'    => Controls_Manager::CHOOSE,
			'label'   => esc_html__( 'Alignment', 'goto' ),
			'options' => array(
				'left' => array(
					'title' => esc_html__( 'Left', 'goto' ),
					'icon'  => 'fa fa-align-left'
				),
				'center' => array(
					'title' => esc_html__( 'Center', 'goto' ),
					'icon'  => 'fa fa-align-center'
				),
				'right' => array(
					'title' => esc_html__( 'Right', 'goto' ),
					'icon'  => 'fa fa-align-right'
				),
			),
			'default'        => 'center',
			'tablet_default' => 'center',
			'mobile_default' => 'center',
			'selectors'      => array(
				'{{WRAPPER}} .ht-pagination' => 'text-align: {{VALUE}};'
			),
		));

		$this->add_responsive_control( 'pagi_space', array(
			'type'       => Controls_Manager::DIMENSIONS,
			'label'      => esc_html__( 'Space', 'goto' ),
			'size_units' => array( 'px', 'em' ),
			'default'    => array(
				'top'      => '30',
				'right'    => '0',
				'bottom'   => '0',
				'left'     => '0',
				'unit'     => 'px',
				'isLinked' => false,
			),
			'tablet_default' => array(
				'top'      => '20',
				'right'    => '0',
				'bottom'   => '20',
				'left'     => '0',
				'unit'     => 'px',
				'isLinked' => false,
			),
			'mobile_default' => array(
				'top'      => '15',
				'right'    => '0',
				'bottom'   => '15',
				'left'     => '0',
				'unit'     => 'px',
				'isLinked' => false,
			),
			'selectors' => array(
				'{{WRAPPER}} .ht-pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
			),
		));

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( 0 == $settings['per_page'] ) {
			return;
		}

		$paged = is_front_page() ? get_query_var( 'page' ) : get_query_var( 'paged' );
		$paged = $paged ? intval( $paged ) : 1;
		$args  = array(
			'post_type'           => 'ht_tour',
			'ignore_sticky_posts' => 1,
			'post_status'         => 'publish',
			'posts_per_page'      => $settings['per_page'],
			'orderby'             => $settings['orderby'],
			'order'               => $settings['order'],
			'paged'               => $paged,
		);

		switch( $settings['narrow'] ):
			case 'cat':
				if( ! empty( $settings['cat'] ) )
					$args['tax_query'] = array(
						array(
							'taxonomy' => 'ht_tour_cat',
							'field'    => 'term_id',
							'terms'    => $settings['cat']
						)
					);
				break;
			case 'dest':
				if( ! empty( $settings['dest'] ) ){
					$id_arr = array();
					foreach( $settings['dest'] as $k ){
						$id_arr[] = function_exists( 'fw_get_db_post_option' ) ? fw_get_db_post_option( $k, 'tour_id' ) : array();
					}
					$id_arr = array_unique( call_user_func_array( 'array_merge_recursive', $id_arr ) );

					if( ! empty( $id_arr ) ){
						$args['post__in'] = $id_arr;
					}
				}
				break;
			case 'post':
				if( ! empty( $settings['post'] ) )
					$args['post__in'] = $settings['post'];
				break;
		endswitch;

		if ( in_array( $settings['narrow'], array( 'dest', 'post' ), true ) && empty( $args['post__in'] ) ) {
			return;
		}

		$query = new \WP_Query( $args );

		/*GENERATE UNIQI ID*/
		$tiny_slider_id = uniqid( 'wd-tour-id-' );

		$columns = isset( $settings['columns']) ? $settings['columns'] : 3;
        $tablet_columns = isset( $settings['columns_tablet']) ? $settings['columns_tablet'] : 2;
        $mobile_columns = isset( $settings['columns_mobile']) ? $settings['columns_mobile'] : 1;

		/*RENDER CAROUSEL*/
		$this->renderCarousel( $tiny_slider_id, $settings['layout'], $columns, $tablet_columns, $mobile_columns );

		/*GENERATE CAROUSEL OPTIONS*/
		$tiny_slider_data = $this->carouselOptions( $settings['layout'], $columns, $tablet_columns, $mobile_columns );

		/*CLASSES*/
		$classes = 'wd-tours-layout-'. $settings['layout'] .' ht-grid ht-grid-'. $columns .' ht-grid-tablet-'. $tablet_columns .' ht-grid-mobile-'. $mobile_columns;

		/*ADD `not-real-class` FOR SLIDER ANIMATION*/
		$layout_name = 'carousel' == $settings['layout'] ? 'not-real-slider' : '';

		?>
		<div class="wd-tours">
			<div class="<?php echo esc_attr( $classes ); ?>">
				<div class="wd-tours-content <?php echo esc_attr( $layout_name ); ?>" id="<?php echo esc_attr( $tiny_slider_id ); ?>" <?php echo wp_kses_post( $tiny_slider_data ); ?>>
					<?php
						$unit              =  function_exists( 'fw_get_db_ext_settings_option' ) ? goto_unit( fw_get_db_ext_settings_option( 'tour', 'unit' ) ) : '&#36;';
						$symbol_post       =  function_exists( 'fw_get_db_ext_settings_option' ) ? fw_get_db_ext_settings_option( 'tour', 'symbol-pos' )  : 'left';

						while( $query->have_posts() ):
							$query->the_post();

							if( ! function_exists( 'FW' ) ) return;

							/*VARIABLE*/
							$price      = fw_get_db_post_option( get_the_ID(), 'price', 0 );
							$sale_price = fw_get_db_post_option( get_the_ID(), 'sale_price', 0 );
							$days       = fw_get_db_post_option( get_the_ID(), 'days', 0 );

							$rating     = function_exists( 'fw_ext_feedback_stars_get_post_rating' ) ? fw_ext_feedback_stars_get_post_rating() : array( 'count' => 0 );


							$img_id     = get_post_thumbnail_id( get_the_ID() );
							$img_alt    = goto_img_alt( $img_id, esc_attr__( 'Tour list image', 'goto' ) );
							$img_src    = ! empty( $img_id ) ? get_the_post_thumbnail_url( get_the_ID(), 'medium_large' ) : get_template_directory_uri() . '/images/tour/370x240.png';
							$terms      = wp_get_post_terms( get_the_ID(), 'ht_tour_cat' );
						?>
						<div class="ht-grid-item <?php echo ( 0 != $sale_price ) ? 'wdt-has-sale' : ''; ?>" <?php goto_schema_markup( 'creative_work' ); ?>>
							<?php if( 0 != $sale_price && 'carousel' == $settings['layout'] ): ?>
								<div class="wdt-percent-sale">-<?php echo round( ( ( $price - $sale_price ) / $price ) * 100 ); ?>%</div>
							<?php endif; ?>

							<div class="wd-tour-item">
								<?php /*HEAD*/ ?>
								<div class="wd-tour-head">
									<?php if( 0 != $price && 'grid' == $settings['layout'] ): ?>
										<span class="tli-price">
											<span><?php goto_price_unit( $symbol_post, $unit, $price ); ?></span>
											<?php if( 0 != $sale_price ): ?>
												<span class="tli-sale-price"><?php goto_price_unit( $symbol_post, $unit, $sale_price ) ?></span>
											<?php endif; ?>
										</span>
									<?php endif; ?>
									<a href="<?php the_permalink(); ?>">
										<img src="<?php echo esc_url( $img_src ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
									</a>
								</div>

								<?php /*CONTENT*/ ?>
								<div class="wd-tour-content" itemprop="text">
									<h3 class="wdtc-title entry-title" itemprop="headline"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>

									<?php if( $terms && 'grid' == $settings['layout'] && '#' != goto_template_name() ): ?>
										<span class="wdtc-cat">
											<?php
												$t = count( $terms ) - 1;
												foreach( $terms as $s => $k ):
													$dot = $s == $t ? '' : ', ';
													echo '<a href="'. goto_template_name() . '?category=' . $k->term_id .'">'. $k->name .'</a>' . $dot;
												endforeach;
											?>
										</span>
									<?php endif; ?>

									<time class="sr-only" itemprop="datePublished" datetime="<?php echo get_the_time( 'c' ); ?>"><?php echo get_the_date(); ?></time>

									<span class="wdt-aver">
										<?php if( $rating['count'] > 0 ): ?>
											<span class="tour-average"><?php echo esc_html( round( $rating['average'], 1 ) ); ?></span>
										<?php endif; ?>

										<span class="tour-review-count">
											<?php
												printf(
													_nx(
														'1 review',
														'%s review(s)',
														number_format_i18n( $rating['count'] ),
														'review count',
														'goto'
													),
													number_format_i18n( $rating['count'] )
												);
											?>
										</span>
									</span>

									<?php if( 'grid' == $settings['layout'] ): ?>
										<span class="wdt-time">
											<span class="goto-icon-clock"></span>
											<strong>
												<?php
													printf(
														_nx(
															'1 day',
															'%1$s days',
															$days,
															'day of the week',
															'goto'
														),
														$days
													);
												?>
											</strong>
										</span>
									<?php endif; ?>

									<?php if( 'carousel' == $settings['layout'] ): ?>
										<span class="wdt-price">
											<?php
											esc_html_e( 'Start from - ', 'goto' );
											if( 0 != $sale_price )
												echo '<strong>'. $unit . $sale_price .'</strong>';
											else
												echo '<strong>'. $unit . $price .'</strong>';
											?>
										</span>
									<?php endif; ?>
								</div>
							</div>
						</div>
					<?php
						endwhile;

						if ( 'yes' == $settings['pagi'] && 'grid' == $settings['layout'] ) {
							goto_paging( $query );
						}

						wp_reset_postdata();
					?>
				</div>
			</div>
		</div>
	<?php
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new goto_tour_post() );
